--------------------------------------------------------------------------------------------
-- Generate seed lists
-- determine that a seed is or isn't symetrical
-- determine if a seed is a symetrical version of another
-- r - rotation
-- p - mirror axis is perpendicular to the boundary
-- b - mirror axis is the boundary

-- p on diag- the units that must paledrome are not one cell we have 11,13,22,32,101,111,123,213,202,222,332,3333332,133333,
       -- so parsing the seed to identify symetric units has become very hard
--------------------------------------------------------------------------------------------
local function l2t(logical)
   res = "null"
   if (logical) then
      res = "T"
   else
      res = "F"
   end
   return (res)
end
--------------------------------------------------------------------------------------------
local function testMirrorB(seed,mirrorChars,seed_N_File)
   symetrical = false
   if (#seed > 1) then
      symetrical = false
      for i = 1,#seed do
         symetrical = mirrorChars[seed:sub(i,i)]
         if( not symetrical) then
            break
         end
      end
   end
   return(symetrical)
end
--------------------------------------------------------------------------------------------
local function testMirror(seed,seedI1,mirrorPairs,seed_N_File,ty)
   symetrical = (seedI1 > 0)
--   seed_N_File:write("("..seed..":"..ty..":"..seedI1..")")
   for i = 1,seedI1 do	
      pair = string.sub(seed,i,i)..string.sub(seed,#seed+1-i,#seed+1-i)
      symetrical = mirrorPairs[pair]
--      seed_N_File:write(pair..l2t(symetrical)..",")
      if(not symetrical) then
         break
      end
   end
   return(symetrical)
end
--------------------------------------------------------------------------------------------
local function seedSym(seedP,seed_N_File)
   SymetricRotate = 
         {["00"]=true,  ["01"]=false, ["02"]=false, ["03"]=false,
          ["10"]=false, ["11"]=false, ["12"]=true,  ["13"]=false,
          ["20"]=false, ["21"]=true,  ["22"]=false, ["23"]=false,
          ["30"]=false, ["31"]=false, ["32"]=false, ["33"]=true   }
   SymetricMirrorPerP = 
         {["00"]=true,  ["01"]=false, ["02"]=false, ["03"]=false,
          ["10"]=false, ["11"]=true,  ["12"]=false, ["13"]=false,
          ["20"]=false, ["21"]=false, ["22"]=true,  ["23"]=false,
          ["30"]=false, ["31"]=false, ["32"]=false, ["33"]=true   }
   SymetricMirrorBoundry = 
         {["0"]=true, ["1"]=false, ["2"]=false, ["3"]=true}
   SymetricCenter = 
         {["0"]="prb", ["1"]="pb", ["2"]="pb", ["3"]="prb"}
   
 
   local seed = seedP
   while (string.sub(seed,1,1) == '0') do
      seed = string.sub(seed,2)
   end
   while (string.sub(seed,#seed) == '0') do
      seed = string.sub(seed,1,#seed-1)
   end
   
--   seed_N_File:write("->"..seed..",")
   ret=false
   if(#seed >0 ) then
      centre = "prb-"
      if (#seed%2 == 1) then
         centre = SymetricCenter[seed:sub(#seed//2+1,#seed//2+1)]
      end
--      seed_N_File:write("->"..centre..","..#seed%2)
      if (centre:match("p")) then 
         ret = ret or testMirror(seed, #seed//2, SymetricMirrorPerP, seed_N_File,"p")
      end
      if (centre:match("r")) then 
         ret = ret or testMirror(seed, #seed//2, SymetricRotate,     seed_N_File,"r")
      end
      if (centre:match("b")) then 
         ret = ret or testMirrorB(seed, SymetricMirrorBoundry, seed_N_File)
      end
   end
   return ret
end
--------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------
local function checkSeedList()
   local seedListName = "../seedList.txt"
   local seedFile = io.open ( seedListName , "r")
   
   local seedList_N_Name = "../seedList_n.txt"
   local seed_N_File = io.open ( seedList_N_Name , "w")
   
   local seed = seedFile:read("*line")
   while seed do
      seed_N_File:write(seed.." ")
      if (seedSym(seed,seed_N_File)) then
         seed_N_File:write(" sym\n")
      else
         seed_N_File:write(" -sym\n")
      end
      seed = seedFile:read("*line")
   end
end
--------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------
local function GenMirrorPerp(seedArray)
   perpSeedArray = {}
   for i = 1, #seedArray do
      perpSeedArray[#seedArray-i+1] = seedArray[i]
   end
   return(perpSeedArray)
end
--------------------------------------------------------------------------------------------
local function GenMirrorRot(seedArray)
   rotArray = {0,2,1,3}
   rotSeedArray = {}
   for i = 1, #seedArray do
      rotSeedArray[#seedArray-i+1] = rotArray[seedArray[i]+1]
   end
   return(rotSeedArray)
end

--------------------------------------------------------------------------------------------
local function textSeed(seedArray)
   local digits = {"0","1","2","3"}
   seed = ""
   for i = 1,#seedArray do
      seed = seed..digits[seedArray[#seedArray-i+1]+1]
   end
   return(seed)
end
--------------------------------------------------------------------------------------------
local function newSeed(seed_N_File,seedArray, seedCnt)
   seed = textSeed(seedArray)
   if ( not seedList[seed]) then
      if (not seedSym(seed,seed_N_File)) then
         seed_N_File:write(seed.."\n")
         seedList[seed] = true
         mirrorPert = textSeed(GenMirrorPerp(seedArray))
         seed_N_File:write(mirrorPert.." perp\n")
         seedList[textSeed(GenMirrorPerp(seedArray))] = true
         
         mirrorRotA = GenMirrorRot(seedArray)
         mirrorRot = textSeed(mirrorRotA)
	 seed_N_File:write(mirrorRot.." rot\n")
         seedList[textSeed(mirrorRotA)] = true
         
         mirrorRotPerp = textSeed(GenMirrorPerp(mirrorRotA))
         seed_N_File:write(mirrorRotPerp.." rot-perp\n")
         seedList[mirrorRotPerp] = true
         seedCnt = seedCnt+1
      else
         seed_N_File:write(seed.." sym\n")
      end
   else
      seed_N_File:write(seed.." Dup\n")
   end
   return(seedCnt)
end

--------------------------------------------------------------------------------------------
local function GenSeedList()
   local doneSeed = {}
   local seedList_N_Name = "../seedList_n.txt"
   local seed_N_File = io.open ( seedList_N_Name , "w")
   seed_N_File:write("GenSeedList\n")
   seedCnt = 0
   seedArray = {0,1}
   seedPtr = 1
   seedArray[seedPtr] = 0
   reset = false
   while (seedCnt < 500) do
      if (seedArray[seedPtr] < 3) then
         seedArray[seedPtr] = seedArray[seedPtr] + 1
         seedCnt = newSeed(seed_N_File, seedArray, seedCnt)
         if (reset) then 
            reset = false
            seedPtr = 1
         end
      else
        if (seedPtr > 1) then
           seedArray[seedPtr] = 0
        else
           seedArray[seedPtr] = 1
        end
        seedPtr = seedPtr + 1
        if (#seedArray < seedPtr) then
           seedArray[seedPtr] = 1
           seedPtr = 1
           seedCnt = newSeed(seed_N_File, seedArray, seedCnt)
           if (reset) then 
	      reset = false
	      seedPtr = 1
           end
        else
           reset = true
        end
      end
   end
end
--------------------------------------------------------------------------------------------

seedList = {}
--checkSeedList()
GenSeedList()